// digital caliper display Ver 1.2 by MK
// Pic 16F887
// Compiler CCS Ver 4.104
// 21.05.2010
//
// Status = ready for use
//
// copyright by Martin Klein only for private use
//

#include <16F887.h>
#include <stdlib.h>

#use delay (clock=20000000)
#use rs232(baud=115200,bits=8,parity=N,xmit=PIN_C6,rcv=PIN_C7)

#fuses  HS,NOWDT,NOPROTECT,NOBROWNOUT

#define  noPoint 0x80 
#define  minus   0x8A
#define  Blank   0x8F


/*  pin-out

    PIN_A0  40    Mode/Dat
    PIN_A1  42    /Write
      
    PIN_A6  44    OSC-1   
    PIN_A7  45    OSC-2
    
    PIN_B0  48    clock_caliper
    PIN_B1  49    data_caliper    

    PIN_C7  53    RS232 RX
    PIN_C6  55    RS232 TX
    


----------------------------------------------------------------
   ICM7218A

   Mode = control data  ID0... ID3 dont care when writing control data
   Data = Bit value     ID4... ID6 dont care when writing HEX/Code B Data

    PIN_D0  56    ID0   = Data
    PIN_D1  57    ID1   = Data
    PIN_D2  58    ID2   = Data
    PIN_D3  59    ID3   = Data
    PIN_D4  60    ID4   = /shutdown            High normal operating
    PIN_D5  61    ID5   = /decoding            Low  decoding
    PIN_D6  62    ID6   = ( Hex /Code B  )     Low  code B
    PIN_D7  63    ID7   = Data Coming / Data   High / low for decimal point
------------------------------------------------------------------

*/

// Variablen
char i         = 0;
char restart   = 0;

char LD[8]        ;        // 7Segment 1..6 in use
char Nibble[7];            // Nibble
char BitNibble[4];         // Bit Nibble
 

// -----------------------------------------------------------------

char waitForStart()
{  
   for(;;)
   {
      if(input(PIN_B0)& input(PIN_B1)) // if clock and data high
      {       
         delay_ms(3);                  // wait 3ms
         return 1;                     // position is ok
      }
   }     
   return 0;                           
}

int waitForBit()
{
   while(!input(PIN_B0))                  // if clock high
   {
   }
    while(input(PIN_B0))                  // if clock low
   {
   }  
   
   return(input(PIN_B1));                 // to read bit
}

int waitForNibble()
{
   char bit1 = 0,bit2 =0 ,bit3 = 0,bit4 = 0,summe = 0;
   
   bit1  = waitForBit();                    // bit 1
   bit2  = waitForBit();                    // bit 2
   bit3  = waitForBit();                    // bit 3
   bit4  = waitForBit();                    // bit 4
      
   summe = bit1+ (bit2*2)+(bit3*4) + (bit4*8);    // account value 
   
   return summe;                          // return value   
}

void ICM7218_init_mode(char data)
{
   output_low(PIN_A0);  // Mode low
   output_high(PIN_A1); // no Write high
   output_high(PIN_A0); // Mode word
   output_D(data);      // Init data
   output_low(PIN_A1);  // Write
   output_high(PIN_A1); // no Write
   output_low(PIN_A0);  // Mode low
}

void ICM7218_init_end(char data)
{
   output_low(PIN_A0);  // Mode low
   output_high(PIN_A1); // no Write
   output_high(PIN_A0); // Mode high
   output_D(data);      // Init data 
   output_low(PIN_A1);  // Write
   output_high(PIN_A1); // no Write
   output_low(PIN_A0);  // Mode low
}
void ICM7218_value( char value )
{
      output_low(PIN_A0);  // Mode low
      output_D(value);     // Init data 
      output_low(PIN_A1);  // Write low
      output_high(PIN_A1); // no Write high
}


void ICM7218_complete (char LD1,LD2,LD3,LD4,LD5,LD6)
{
      ICM7218_init_mode(0x90);   // Start
      ICM7218_value (LD6);
      ICM7218_value (LD5);
      ICM7218_value (LD4);
      ICM7218_value (LD3);
      ICM7218_value (LD2);
      ICM7218_value (LD1);    
      ICM7218_value (0x0F);      // are not used
      ICM7218_value (0x0F);      // are not used
      ICM7218_init_end(0x10);    // Stop 
}

#use fast_io(B)

void main()
{

   ICM7218_complete ( minus,minus,1,noPoint+2,minus,minus);
   delay_ms(3000);
   
   
   waitForStart();            // first startposition
   
   for(;;)
   {
                
      if (restart >= 50)      // synchronisation routine
      { 
         waitForStart();      // to relocate startposition
         restart = 0;
      }
      
      for (i=0 ; i < 7  ; i++)
      {
         Nibble[i] = waitForNibble(); // write pre-value
      }
      
      BitNibble[1] = Nibble[6] & 0x01; // detect minus
      BitNibble[3] = Nibble[6] & 0x04; // detect metrisch
            
      
//value transfer with inch-point or metrisch-point      
      for (i=0 ; i < 7  ; i++)
      {
         LD[i+1] = Nibble[i] + noPoint;
         if ((BitNibble[3] == 4) & (i == 2)) // if metrisch
         {
            LD[3] = LD[3] - noPoint;         // set metrisch point
         }
         if ((BitNibble[3] == 0) & (i == 3)) // if inch
         {
            LD[4] = LD[4] - noPoint;         // set inch point
            
         }
      }

// inch accurate output form
      if (BitNibble[3] == 0)     // if inch
      {
         LD[5] = Blank;          // show dark segment
         LD[6] = Blank;          // show dark segment
         if(BitNibble[1] == 1)   // if minus
         {
            LD[5] = minus;       // show minus symbol 
         }
      }
 
// metrisch accurate output form
      if ((Nibble[5] ==0) && (Nibble[4] >=1)  && (BitNibble[3] == 4))
      {
         LD[6] = Blank;          // show dark segment
         if(BitNibble[1] == 1)   // if minus
         {
            LD[6] = minus;       // show minus symbol
         }
      } 
      
      if ((Nibble[5] ==0) && (Nibble[4] ==0) && (Nibble [3] >=1) && (BitNibble[3] == 4))
      {
         LD[6] = Blank;          // show dark segment
         LD[5] = Blank;          // show dark segment
         if(BitNibble[1] == 1)   // if minus
         {
            LD[5] = minus;       // show minus symbol
         }
      }

      if ((Nibble[5] ==0) && (Nibble[4] ==0) && (Nibble [3] ==0) && (BitNibble[3] == 4))
      {
         LD[6] = Blank;          // show dark segment
         LD[5] = Blank;          // show dark segment
         LD[4] = Blank;          // show dark segment
         if(BitNibble[1] == 1)   // if minus
         {
            LD[4] = minus;       // show minus symbol
         }
      }
      
// display output 
      ICM7218_complete ( LD[6],LD[5],LD[4],LD[3],LD[2],LD[1]);
      
      printf("HiThere");
      restart++;
   }
}
