// Gray-Code-Simulation by MK
// Pic 12F683
// Compiler CCS Ver 4.109
// 23.11.2010
//
// Ver 1.0
//
// Gray-Code frequenz ca. 0.157 Hz... 1,947 kHz ( Poti 2,5K / Resistor 4K7 )
//
// Status = ready to use
//
// copyright by Martin Klein only for private use
//

#include <12F683.h>
#include <stdlib.h>

#fuses   INTRC_IO,NOWDT,NOPROTECT,NOBROWNOUT
#use     standard_io(A)
#use     delay (clock=8000000)

/*  pin-out Pic
  

   PIN_GP2  A2      Speed    ( 250R Poti ber 1K ) 
   PIN_GP5  A5      Stopp
   PIN_GP4  A4      Drehrichtung
   
   PIN_GP0  A0      Encoder-Out A
   PIN_GP1  A1      Encoder-Out B
    
*/

// Variablen


char a = 1;

long      i =    0;
long   wert =  100;
long  value =   57;


// -----------------------------------------------------------------

#INT_TIMER0
void timer() 
{

      if ( i >= wert)  
      {
         i = 0;
         if ( a == 0  && input (PIN_A5) == 1)
         {

            if ( input (PIN_A4) == 1 )
            {           
               output_low(PIN_A0);
               output_low(PIN_A1);
            }
            else
            {
               output_low(PIN_A0);
               output_low(PIN_A1);         
            }                     
         }

         if ( a == 1 && input (PIN_A5) == 1 )
         {
            if ( input (PIN_A4) == 1 )
            {
               output_high(PIN_A0);
               output_low(PIN_A1);
            }
            else
            {
               output_low(PIN_A0);
               output_high(PIN_A1);         
            }
         }
         
         if ( a == 2 && input (PIN_A5) == 1)
         {
            if ( input (PIN_A4) == 1 )
            {
               output_high(PIN_A0);      
               output_high(PIN_A1);
            }
            else
            {
               output_high(PIN_A0);
               output_high(PIN_A1);
            }
         }
  
         if ( a == 3 && input (PIN_A5) == 1 )
         {
            if ( input (PIN_A4) == 1 )
            {
               output_low(PIN_A0);
               output_high(PIN_A1);
            }
            else
            {
               output_high(PIN_A0);
               output_low(PIN_A1);
            }
         }
      
         if ( a == 4 && input (PIN_A5) == 1 )
         {
            if ( input (PIN_A4) == 1 )
            {      
               output_low(PIN_A0);
               output_low(PIN_A1);
            }
            else
            {
               output_low(PIN_A0);
               output_low(PIN_A1);
            }         
         }
         if ( input (PIN_A5) == 1) a++;
         if ( a == 4 && input (PIN_A5) == 1) a=0;
    
      }
      
      i++;        
}

void main()
{

   enable_interrupts(GLOBAL); 
   setup_timer_0(RTCC_INTERNAL|RTCC_DIV_1|RTCC_8_BIT);  
   enable_interrupts(INT_TIMER0);
   setup_adc(ADC_CLOCK_INTERNAL );
   set_adc_channel( 2 );
   setup_adc_ports(sAN2);
   
   for(;;)
   {
         read_adc(ADC_START_ONLY);
         int1 done = adc_done();
         while(!done) 
         {
            done = adc_done();
         }
         value=read_adc(ADC_READ_ONLY);
         wert = ((value + value)+1)*((value + value )+1);
   }
}

