// digital caliper display Ver 1.6 by MK
// Pic 16F887
// Compiler CCS Ver 4.104
// 15.09.2010
//
// prog for 2 x 24Bit caliper and double-value-switch
//
//
// copyright by Martin Klein only for private use
//

#include <16F887.h>
#include <stdlib.h>

#use delay (clock=20000000)
#use rs232(baud=115200,bits=8,parity=N,xmit=PIN_C6,rcv=PIN_C7)

#fuses  HS,NOWDT,NOPROTECT,NOBROWNOUT

#define  noPoint 0x80 
#define  minus   0x0A
#define  Blank   0x0F


/*  pin-out

    PIN_A0  40    Mode/Dat
    PIN_A1  42    /Write
      
    PIN_A6  44    OSC-1   
    PIN_A7  45    OSC-2
    
    PIN_B0  48    clock_caliper
    PIN_B1  49    data_caliper    
    PIN_B2  50    double-value-switch
    
    PIN_C7  53    RS232 RX
    PIN_C6  55    RS232 TX
    
    


----------------------------------------------------------------
   ICM7218A

   Mode = control data  ID0... ID3 dont care when writing control data
   Data = Bit value     ID4... ID6 dont care when writing HEX/Code B Data

    PIN_D0  56    ID0   = Data
    PIN_D1  57    ID1   = Data
    PIN_D2  58    ID2   = Data
    PIN_D3  59    ID3   = Data
    PIN_D4  60    ID4   = /shutdown            High normal operating
    PIN_D5  61    ID5   = /decoding            Low  decoding
    PIN_D6  62    ID6   = ( Hex /Code B  )     Low  code B
    PIN_D7  63    ID7   = Data Coming / Data   High / low for decimal point
------------------------------------------------------------------

*/

// Variablen
//char restart               = 0;

char i                     = 0;
char LD[7]                    ;        // 7Segment 1..6 in use 
char Bit[25]                  ;        // 24 Bits
long long CaliperValue     = 0;        // Basic Value
long long MetrischValue    = 0;


// -----------------------------------------------------------------

char waitForStart()
{  
   for(;;)
   {
      if(input(PIN_B0)& input(PIN_B1)) // if clock and data high
      {       
         delay_ms(3);                  // wait 3ms
         return 1;                     // position is ok
      }
   }     
   return 0;                           
}

int waitForBit()
{
   while(!input(PIN_B0))                  // if clock high
   {
   }
    while(input(PIN_B0))                  // if clock low
   {
   }  
   
   return(input(PIN_B1));                 // to read bit
}

void waitFor24Bit()
{
      char nix;
      for (i=1 ; i < 25  ; i++)
      {
         nix = waitForBit();     // first 24 Bit for nothing
      }
      for (i=1 ; i < 25  ; i++)
      {
         Bit[i] = waitForBit();  // second 24 Bit 
      }
   

}

void ICM7218_init_mode(char data)
{
   output_low(PIN_A0);  // Mode low
   output_high(PIN_A1); // no Write high
   output_high(PIN_A0); // Mode word
   output_D(data);      // Init data
   output_low(PIN_A1);  // Write
   output_high(PIN_A1); // no Write
   output_low(PIN_A0);  // Mode low
}

void ICM7218_init_end(char data)
{
   output_low(PIN_A0);  // Mode low
   output_high(PIN_A1); // no Write
   output_high(PIN_A0); // Mode high
   output_D(data);      // Init data 
   output_low(PIN_A1);  // Write
   output_high(PIN_A1); // no Write
   output_low(PIN_A0);  // Mode low
}
void ICM7218_value( char value )
{
      output_low(PIN_A0);  // Mode low
      output_D(value);     // Init data 
      output_low(PIN_A1);  // Write low
      output_high(PIN_A1); // no Write high
}


void ICM7218_complete (char LD1,LD2,LD3,LD4,LD5,LD6)
{
      ICM7218_init_mode(0x90);   // Start
      ICM7218_value (LD6);
      ICM7218_value (LD5);
      ICM7218_value (LD4);
      ICM7218_value (LD3);
      ICM7218_value (LD2);
      ICM7218_value (LD1);    
      ICM7218_value (0x0F);      // are not used
      ICM7218_value (0x0F);      // are not used
      ICM7218_init_end(0x10);    // Stop 
}

void BasicValue()
{
      long long    a = 1;

      CaliperValue   = 0;
    
      
      for (i=1 ; i < 21  ; i++)  // negativ Value
      {
         CaliperValue = CaliperValue  +( Bit[i]*a);
         a=a*2;
      }
      
      if( Bit[24] == 1)          // positiv Value
      {   
         a = 1;
         CaliperValue   = 0;
         for (i=1 ; i < 21  ; i++)
         {
            CaliperValue = CaliperValue  +( !Bit[i]*a);
            a=a*2;
         }
      }
}

void ValueDisassemble( long long value, char out[] )
{

   memset(LD,0,sizeof(LD));
   
   int position=6;
   int i=0;

   while (position>0)
   {
      out[i+1] = value%10;
      value=value/10;
   
      position--;
      i++;
   }  
}

void AccurateOutputMetrisch()
{
// metrisch accurate output form
      if (LD[5] >=1)
      {
         LD[6] = (Blank);           // show dark segment  
         if(Bit[24] == 0)           // if minus
         {
            LD[6] = minus;          // show minus symbol
         }      
      
      }
  
      if ((LD[5] ==0) && (LD[4] >=1))
      {
         LD[6] = (Blank);           // show dark segment
         LD[5] = (Blank);           // show dark segment   
         if(Bit[24] == 0)           // if minus
         {
            LD[5] = minus;          // show minus symbol
         }
      } 
      
      if ((LD[5] ==0) && (LD[4] ==0) && (LD[3] >=1))
      {
         LD[6] = (Blank);           // show dark segment
         LD[5] = (Blank);           // show dark segment
         LD[4] = (Blank);           // show dark segment         
         if(Bit[24] == 0)           // if minus
         {
            LD[4] = minus;          // show minus symbol
         }
      }

      if ((LD[5] ==0) && (LD[4] ==0) && (LD[3] ==0))
      {
         LD[6] = (Blank);           // show dark segment
         LD[5] = (Blank);           // show dark segment
         LD[4] = (Blank);           // show dark segment
         
         if(Bit[24] == 0)           // if minus
         {
            LD[4] = minus;          // show minus symbol
         }
      }
           
      
      LD[1] = LD[1] + noPoint;
      LD[2] = LD[2] + noPoint;
      LD[4] = LD[4] + noPoint;
      LD[5] = LD[5] + noPoint;
      LD[6] = LD[6] + noPoint;      


}
#use fast_io(B)

void main()
{
   ICM7218_complete ( minus+noPoint,minus+noPoint,1,noPoint+6,minus+noPoint,minus+noPoint);
   delay_ms(3000);


   waitForStart();            // first startposition

   for(;;)
   {
     
      waitFor24Bit();  
      BasicValue();           // Row Value
      MetrischValue = (((CaliperValue * 254 )/ 2048));
      
      if ((input(PIN_B2)) == 1)  // double-value
      { 
           MetrischValue = ( MetrischValue * 2 );
      }
      
      ValueDisassemble( MetrischValue, LD);
      AccurateOutputMetrisch();
           
      ICM7218_complete ( LD[6],LD[5],LD[4],LD[3],LD[2],LD[1]);

   }
}


