// digital caliper display Ver 2.5 by MK
// Pic 16F887
// Compiler CCS Ver 4.109
// 24.01.2011
//
// prog for BCD-Code and 48Bit caliper with double-value
//
// Status = ready for use ( not perfect, but it works )
//
// copyright by Martin Klein only for private use
//

#include <16F887.h>
#include <stdlib.h>

#use delay (clock=20000000)
#use rs232(baud=115200,bits=8,parity=N,xmit=PIN_C6,rcv=PIN_C7)

#fuses  HS,NOWDT,NOPROTECT,NOBROWNOUT

#define  noPoint 0x80 
#define  minus   0x8A
#define  Blank   0x8F

/*  pin-out Pic

    PIN_A0  40    Mode/Dat
    PIN_A1  42    /Write
    PIN_A2  43    master /slave
    
    PIN_A6  44    OSC-1   
    PIN_A7  45    OSC-2
    
    PIN_B0  48    clock_caliper
    PIN_B1  49    data_caliper    
    PIN_B2  50    double_Value on/off
    PIN_B3  51    48Bit or BCD-Code caliper 
    
    PIN_C6  62    RS232 TX    
    PIN_C7  63    RS232 RX

    
 
----------------------------------------------------------------
   ICM7218A

   Mode = control data  ID0... ID3 dont care when writing control data
   Data = Bit value     ID4... ID6 dont care when writing HEX/Code B Data

    PIN_D0  56    ID0   = Data
    PIN_D1  57    ID1   = Data
    PIN_D2  58    ID2   = Data
    PIN_D3  59    ID3   = Data
    PIN_D4  60    ID4   = /shutdown            High normal operating
    PIN_D5  61    ID5   = /decoding            Low  decoding
    PIN_D6  62    ID6   = ( Hex /Code B  )     Low  code B
    PIN_D7  63    ID7   = Data Coming / Data   High / low for decimal point
------------------------------------------------------------------

*/

// Variablen

volatile int ende = 0 ;       // interlock 
char send_sign    = 0 ;       // minus or plus
char i            = 0 ;       // free value
char value_send   = 0 ;       // 
char buffer[32]       ;       // free buffer
char LD[7]            ;       // 7Segment 1..6 in use
char BitNibble[4]     ;       // Bit Nibble
char BN           = 0 ;       // Bit Master-Pic minus
char Bit[25]          ;       // 24 Bits
long long CaliperValue     = 0;    // Basic Value
long long MetrischValue    = 0;    // 48Bit caliper 
long long Nibble[7]           ;    // Nibble
long long NM[7]               ;    // Nibble-Master-Pic
       long long  MMvalue = 0 ;    // Master-Caliper-Value from Uart
       long long   Mvalue = 0 ;    // own Caliper
signed long long   Zvalue = 0 ;    // adjusted amount

// -----------------------------------------------------------------

// Interrupt 
#int_rda

void serial_isr()
{
int c = getc();
static int idx;

#define countof(arr) (sizeof(arr)/sizeof(arr[0]))
    
   if(ende)
   {
      return;
      value_send = 0;
   }
   value_send = 1;
   if(c == 0xaa)
   {
      idx = 0;
      return;
   }
   if(c == 0xff)
   {
      ende = idx;
      value_send = 0;
      return;
   }
   buffer[idx++] = c;
   
   if(idx >= countof(buffer) ) idx = countof(buffer) - 1;
}

void Value_isr()
{
   if ( value_send == 0)
   {
      for (i=0 ; i < 7  ; i++)
      {
         NM[i] = buffer[i];
      }
      BN = buffer[6];
      ende = 0;
   }
}

void BasicValue()
{
  long long    a = 1;

  CaliperValue   = 0;
    

  for (i=1 ; i < 21  ; i++)  // negativ Value
  {
     CaliperValue = CaliperValue  +( Bit[i]*a);
     a=a*2;
  }
  
      
  if( Bit[24] == 1 )          // positiv Value
  {   
     a = 1;
     CaliperValue   = 0;
     for (i=1 ; i < 21  ; i++)
     {
        CaliperValue = CaliperValue  +( !Bit[i]*a);
        a=a*2;
     }
  }
}

void ValueDisassemble_48Bit( signed long long value, char out[] )
{

   memset(LD,0,sizeof(LD));
   
   int position=6;
   int i=0;

   while (position>0)
   {
      out[i+1] = value%10;
      value=value/10;
   
      position--;
      i++;
   }  
}

char waitForStart()
{  
   for(;;)
   {
      if(input(PIN_B0)& input(PIN_B1)) // if clock and data high
      {       
         delay_ms(3);                  // wait 3ms
         return 1;                     // position is ok
      }
   }     
   return 0;                           
}

int waitForBit()
{

   while(!input(PIN_B0))                  // if clock high
   {
   }
           
   while(input(PIN_B0))                  // if clock low
   {
   }  

   return(input(PIN_B1));                 // to read bit
}

int waitForNibble()
{
   char bit1 = 0,bit2 =0 ,bit3 = 0,bit4 = 0,summe = 0;
   
   bit1  = waitForBit();                    // bit 1
   bit2  = waitForBit();                    // bit 2
   bit3  = waitForBit();                    // bit 3
   bit4  = waitForBit();                    // bit 4
   
   summe = bit1+ (bit2*2)+(bit3*4) + (bit4*8);    // account value 
   
   return summe;                          // return value   
}

void ICM7218_init_mode(char data)
{
   output_low(PIN_A0);  // Mode low
   output_high(PIN_A1); // no Write high
   output_high(PIN_A0); // Mode word
   output_D(data);      // Init data
   output_low(PIN_A1);  // Write
   output_high(PIN_A1); // no Write
   output_low(PIN_A0);  // Mode low
}

void ICM7218_init_end(char data)
{
   output_low(PIN_A0);  // Mode low
   output_high(PIN_A1); // no Write
   output_high(PIN_A0); // Mode high
   output_D(data);      // Init data 
   output_low(PIN_A1);  // Write
   output_high(PIN_A1); // no Write
   output_low(PIN_A0);  // Mode low
}
void ICM7218_value( char value )
{
      output_low(PIN_A0);  // Mode low
      output_D(value);     // Init data 
      output_low(PIN_A1);  // Write low
      output_high(PIN_A1); // no Write high
}


void ICM7218_complete (char LD1,LD2,LD3,LD4,LD5,LD6)
{
      ICM7218_init_mode(0x90);   // Start
      ICM7218_value (LD6);
      ICM7218_value (LD5);
      ICM7218_value (LD4);
      ICM7218_value (LD3);
      ICM7218_value (LD2);
      ICM7218_value (LD1);    
      ICM7218_value (0x0F);      // are not used
      ICM7218_value (0x0F);      // are not used
      ICM7218_init_end(0x10);    // Stop 
}

void ValueDisassemble( signed long long value, long long out[] )
{

   memset(LD,0,sizeof(LD));
   
   int position=6;
   int i=0;

   while (position>0)
   {
      out[i] = value%10;
      value=value/10;
   
      position--;
      i++;
   }  
}

void Z_Value_BCD_Code()
{
    
   if ((input (PIN_A2)) == 1) 
   {  
      Zvalue = 0;
      Value_isr();           // value from UART   
      MMvalue = ((NM[0]*1)+(NM[1]*10)+(NM[2]*100)+(NM[3]*1000)+(NM[4]*10000)+(NM[5]*100000)); 
          
      if ( BN == 0)             //  if Master-Caliper plus
      {
           if (BitNibble[1]==1)   // if not minus
           { 
              Zvalue = MMvalue + Mvalue;   
           }
                   
           if (BitNibble[1]==0)  // if minus
           {      
              Zvalue = MMvalue - Mvalue;         
           }        
      }

      if ( BN == 1)                  //  if Master-Caliper minus
      {
           if (BitNibble[1]==1)  // if not minus
           { 
              Zvalue = ((MMvalue * -1)) + Mvalue;   
           }
                   
           if (BitNibble[1]==0)  // if minus
           {      
              Zvalue = ((MMvalue * -1)) - Mvalue;          
           }
       
      }
          
      if ( Zvalue < 0 )       // make minus
      {
           BitNibble[1] = 0;
      }
      
      if ( Zvalue > 0 )
      {
           BitNibble[1] = 1;  // make not minus
      }
         
       
      ValueDisassemble( Zvalue, Nibble);

  }
      
  else
  {
     if ( BitNibble[1] == 0)
     {
      send_sign = 1;
     } 
     
     if ( BitNibble[1] == 1)
     {
      send_sign = 0;
     }     
 
     putc(0xAA);            // starposition
     
     putc( Nibble[0]);
     putc( Nibble[1]);
     putc( Nibble[2]);
     putc( Nibble[3]);
     putc( Nibble[4]);
     putc( Nibble[5]);
     putc( send_sign);
 
     putc(0xFF);            // endposition


  }
}

void Z_Value_48Bit()
{
    
   if ((input (PIN_A2)) == 1) 
   {  
      Zvalue = 0;
      Value_isr();           // value from UART 
          
      MMvalue = ((NM[0]*1)+(NM[1]*10)+(NM[2]*100)+(NM[3]*1000)+(NM[4]*10000)+(NM[5]*100000)); 
          
      if ( BN == 0)             //  if Master-Caliper plus
      {
           if (Bit[24]==0)   // if not minus
           { 
              Zvalue = MMvalue + MetrischValue;   
           }
                   
           if (Bit[24]==1)  // if minus
           {      
              Zvalue = MMvalue - MetrischValue;         
           }        
      }

      if ( BN == 1)                  //  if Master-Caliper minus
      {
           if (Bit[24]==0)  // if not minus
           { 
              Zvalue = ((MMvalue * -1)) + MetrischValue;   
           }
                   
           if (Bit[24]==1)  // if minus
           {      
              Zvalue = ((MMvalue * -1)) - MetrischValue;          
           }
       
      }
      
      if ( Zvalue < 0 )       // make minus
      {
           Bit[24] = 1;
      }      
          
      if ( Zvalue > 0 )
      {
           Bit[24] = 0;  // make not minus
      }
          
     
      MetrischValue = Zvalue;
  }
      
  else
  {
     
     putc(0xAA);            // starposition
     
     putc( Nibble[0]);
     putc( Nibble[1]);
     putc( Nibble[2]);
     putc( Nibble[3]);
     putc( Nibble[4]);
     putc( Nibble[5]);
     putc( Bit[24]);

     putc(0xFF);            // endposition

  }
}

void Double_Value ()
{
  if ((input(PIN_B2)) == 0)  // double-value
  {  
     Mvalue = Mvalue * 2;
     ValueDisassemble( Mvalue, Nibble);       
  }
}

void waitFor24Bit()
{
 
  char nix;
  for (i=1 ; i < 25  ; i++)
  {
     nix = waitForBit();     // first 24 Bit for nothing
  }
  for (i=1 ; i < 25  ; i++)
  {
     Bit[i] = waitForBit();  // second 24 Bit 
  }

}

void AccurateOutputMetrisch()
{
// metrisch accurate output form
      if (LD[5] >=1)
      {
         LD[6] = (Blank + noPoint);           // show dark segment  
         if(Bit[24] == 0)           // if minus
         {
            LD[6] = minus + noPoint;          // show minus symbol
         }      
      }
  
      if ((LD[5] ==0) && (LD[4] >=1))
      {
         LD[6] = (Blank + noPoint);           // show dark segment
         LD[5] = (Blank + noPoint);           // show dark segment   
         if(Bit[24] == 0)           // if minus
         {
            LD[5] = minus + noPoint;          // show minus symbol
         }
      } 
      
      if ((LD[5] ==0) && (LD[4] ==0) && (LD[3] >=1))
      {
         LD[6] = (Blank + noPoint);           // show dark segment
         LD[5] = (Blank + noPoint);           // show dark segment
         LD[4] = (Blank + noPoint);           // show dark segment         
         if(Bit[24] == 0)           // if minus
         {
            LD[4] = minus + noPoint;          // show minus symbol
         }
      }

      if ((LD[5] ==0) && (LD[4] ==0) && (LD[3] ==0))
      {
         LD[6] = (Blank + noPoint);           // show dark segment
         LD[5] = (Blank + noPoint);           // show dark segment
         LD[4] = (Blank + noPoint);           // show dark segment
         
         if(Bit[24] == 0)           // if minus
         {
            LD[4] = minus + noPoint;          // show minus symbol
         }
      }
               
      LD[1] = LD[1] + noPoint;
      LD[2] = LD[2] + noPoint;
      LD[4] = LD[4] + noPoint;
      LD[5] = LD[5] + noPoint;
      LD[6] = LD[6] + noPoint;      
}

#use fast_io(B)
void main()
{

   enable_interrupts(GLOBAL);
   enable_interrupts(int_rda);
   memset(NM,0,sizeof(NM));
   memset(buffer,0,sizeof(buffer));

   ICM7218_complete ( minus,minus,2,noPoint+5,minus,minus);
   delay_ms(3000);
   
   waitForStart();            // first startposition 
    
   if ((input(PIN_B3)) == 0)  // 48Bit caliper on
   {  
     
       for(;;)
       { 
       
         waitFor24Bit(); 
         BasicValue();           // Row Value
         MetrischValue = (((CaliperValue * 254 )/ 2048));
         
         ValueDisassemble( MetrischValue, Nibble);
//         Z_Value_48Bit();        // Z1 - Z2 = Z-Summe
         
         if ((input(PIN_B2)) == 0)  // double-value
         { 
            MetrischValue = ( MetrischValue * 2 );
         }

         ValueDisassemble_48Bit( MetrischValue, LD);
         AccurateOutputMetrisch();
         ICM7218_complete ( LD[6],LD[5],LD[4],LD[3],LD[2],LD[1]);
         
       }
   } 

   for(;;)                    // BCD-Code caliper on
   {    
     for (i=0 ; i < 7  ; i++)
      {
         Nibble[i] = waitForNibble(); // write pre-value
      }
      
      BitNibble[1] = Nibble[6] & 0x01; // detect minus
      BitNibble[3] = Nibble[6] & 0x04; // detect metrisch
      
      Mvalue = ((Nibble[0]*1)+(Nibble[1]*10)+(Nibble[2]*100)+(Nibble[3]*1000)+(Nibble[4]*10000)+(Nibble[5]*100000));
      Double_Value ();           // Name is Program
//      Z_Value_BCD_Code();        // Z1 - Z2 = Z-Summe
    
      //value transfer with inch-point or metrisch-point      
      for (i=0 ; i < 7  ; i++)
      {
         LD[i+1] = Nibble[i] + noPoint;
         if ((BitNibble[3] == 4) & (i == 2)) // if metrisch
         {
            LD[3] = LD[3] - noPoint;         // set metrisch point
         }
         if ((BitNibble[3] == 0) & (i == 3)) // if inch
         {
            LD[4] = LD[4] - noPoint;         // set inch point
            
         }
      }

      // inch accurate output form
      if ((Nibble[5] ==0) && (Nibble[4] ==0) &&BitNibble[3] == 0)     // if inch
      {
         LD[5] = Blank;          // show dark segment
         LD[6] = Blank;          // show dark segment
         if(BitNibble[1] == 1)   // if minus
         {
            LD[5] = minus;       // show minus symbol 
         }
      }
      
      if ((Nibble[5] ==0) && (Nibble[4] ==1) &&BitNibble[3] == 0)     // if inch
      {

         LD[6] = Blank;          // show dark segment
         if(BitNibble[1] == 1)   // if minus
         {
            LD[6] = minus;       // show minus symbol 
         }
      }
  
      // metrisch accurate output form
      if ((Nibble[5] ==0) && (Nibble[4] >=1)  && (BitNibble[3] == 4))
      {
         LD[6] = Blank;          // show dark segment
         if(BitNibble[1] == 1)   // if minus
         {
            LD[6] = minus;       // show minus symbol
         }
      } 
      
      if ((Nibble[5] ==0) && (Nibble[4] ==0) && (Nibble [3] >=1) && (BitNibble[3] == 4))
      {
         LD[6] = Blank;          // show dark segment
         LD[5] = Blank;          // show dark segment
         if(BitNibble[1] == 1)   // if minus
         {
            LD[5] = minus;       // show minus symbol
         }
      }

      if ((Nibble[5] ==0) && (Nibble[4] ==0) && (Nibble [3] ==0) && (BitNibble[3] == 4))
      {
         LD[6] = Blank;          // show dark segment
         LD[5] = Blank;          // show dark segment
         LD[4] = Blank;          // show dark segment
         if(BitNibble[1] == 1)   // if minus
         {
            LD[4] = minus;       // show minus symbol
         }
      }

      // display output 
      ICM7218_complete ( LD[6],LD[5],LD[4],LD[3],LD[2],LD[1]);

   }
}
